/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWExpressionTextField;
import filenet.vw.toolkit.design.property.dialog.VWFieldAddRemovePanel;
import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWMapListCellRenderer;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class VWRollBackCheckPointParamPanel
extends JPanel
implements ActionListener,
IVWPropertyChangeListener,
IVWExpressionTextFieldListener,
IVWMapChangedListener {
    private VWToolbarBorder m_booleanBorder = null;
    private VWExpressionTextField m_booleanTextField = null;
    private VWToolbarBorder m_submapBorder = null;
    private JComboBox m_submapComboBox = null;
    private JButton m_goToButton = null;
    private VWToolbarBorder m_fieldBorder = null;
    private VWFieldAddRemovePanel m_fieldAddRemovePanel = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInstructionDefinition m_instructionDef = null;

    public void init(VWAuthPropertyData authPropertyData, int nDisplayMode) {
        this.m_authPropertyData = authPropertyData;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 10);
        if (nDisplayMode == 0) {
            gbCons.insets = new Insets(0, 0, 0, 20);
        }
        this.m_booleanBorder = new VWToolbarBorder(VWResource.s_resumeProcessingExpressionStr);
        this.add((Component)this.m_booleanBorder, gbCons);
        JPanel booleanPanel = this.m_booleanBorder.getClientPanel();
        booleanPanel.setLayout(new GridLayout());
        this.m_booleanTextField = new VWExpressionTextField(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData);
        this.m_booleanTextField.addExpressionTextFieldListener(this);
        booleanPanel.add(this.m_booleanTextField);
        ++gbCons.gridy;
        this.m_submapBorder = new VWToolbarBorder(VWResource.s_mapStr, 0);
        this.add((Component)this.m_submapBorder, gbCons);
        JPanel submapPanel = this.m_submapBorder.getClientPanel();
        submapPanel.setLayout(new BorderLayout());
        this.m_submapComboBox = new JComboBox();
        this.m_submapComboBox.setRenderer(new VWMapListCellRenderer(this.m_authPropertyData));
        this.m_submapComboBox.addActionListener(this);
        submapPanel.add((Component)this.m_submapComboBox, "Center");
        this.m_goToButton = VWImageLoader.createIconButton("goto.gif", VWResource.s_gotoSubmapStr);
        this.m_goToButton.setName("m_goToButton_VWMapSelectionPanel");
        this.m_goToButton.setEnabled(false);
        this.m_goToButton.addActionListener(this);
        submapPanel.add((Component)this.m_goToButton, "After");
        this.initMapComboBox();
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weighty = 1.0;
        gbCons.gridheight = 0;
        gbCons.insets = new Insets(0, 0, 0, 10);
        if (nDisplayMode == 0) {
            ++gbCons.gridx;
            gbCons.gridy = 0;
        }
        this.m_fieldBorder = new VWToolbarBorder(VWResource.s_rollBackFieldsStr);
        this.add((Component)this.m_fieldBorder, gbCons);
        JPanel fieldPanel = this.m_fieldBorder.getClientPanel();
        fieldPanel.setLayout(new GridLayout());
        this.m_fieldAddRemovePanel = new VWFieldAddRemovePanel(this.m_authPropertyData);
        this.m_fieldAddRemovePanel.init(this.m_instructionDef, null, null);
        fieldPanel.add(this.m_fieldAddRemovePanel);
        this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
        this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        try {
            this.m_instructionDef = instructionDef;
            this.initMapComboBox();
            this.m_booleanTextField.removeExpressionTextFieldListener(this);
            this.m_submapComboBox.removeActionListener(this);
            if (this.m_instructionDef != null) {
                String redoFlag = VWInstruction.RollBackCheckPointInstructionGetReDoFlag(this.m_instructionDef);
                String submap = VWInstruction.RollBackCheckPointInstructionGetMap(this.m_instructionDef);
                String[] nonRollBackFields = VWInstruction.RollBackCheckPointInstructionGetNonRolledBackFieldList(this.m_instructionDef);
                this.m_booleanTextField.setText(redoFlag);
                this.m_booleanTextField.setEnabled(true);
                if (submap != null) {
                    this.m_submapComboBox.setSelectedItem(submap);
                } else {
                    this.m_submapComboBox.setSelectedIndex(0);
                }
                this.m_submapComboBox.setEnabled(true);
                this.initRollBackAddRemoveFieldsPanelValue(nonRollBackFields);
            } else {
                this.m_booleanTextField.setText("");
                this.m_booleanTextField.setEnabled(false);
                this.m_submapComboBox.setEnabled(false);
                this.m_fieldAddRemovePanel.init(null, null, null);
            }
            this.m_booleanTextField.addExpressionTextFieldListener(this);
            this.m_submapComboBox.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this);
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        if (this.m_booleanTextField != null) {
            this.m_booleanTextField.addExpressionTextFieldListener(this);
            this.m_booleanTextField = null;
        }
        if (this.m_submapBorder != null) {
            this.m_submapBorder.releaseReferences();
            this.m_submapBorder = null;
        }
        if (this.m_submapComboBox != null) {
            this.m_submapComboBox.removeActionListener(this);
            this.m_submapComboBox = null;
        }
        if (this.m_goToButton != null) {
            this.m_goToButton.removeActionListener(this);
            this.m_goToButton = null;
        }
        if (this.m_fieldBorder != null) {
            this.m_fieldBorder.releaseReferences();
            this.m_fieldBorder = null;
        }
        if (this.m_fieldAddRemovePanel != null) {
            this.m_fieldAddRemovePanel.removeReferences();
            this.m_fieldAddRemovePanel = null;
        }
        this.m_authPropertyData = null;
        this.m_instructionDef = null;
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_submapComboBox)) {
                this.performSubmapAction();
            } else if (event.getSource().equals(this.m_goToButton)) {
                this.performGotoAction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        try {
            Object src = event.getSource();
            IVWPropertyChangeSource changeSrc = (IVWPropertyChangeSource)src;
            Vector items = changeSrc.getItemsChanged();
            switch (event.getID()) {
                case 506: 
                case 511: 
                case 558: {
                    this.setInstructionDefinition(this.m_instructionDef);
                    break;
                }
                case 507: 
                case 512: 
                case 559: {
                    break;
                }
                case 508: 
                case 513: 
                case 560: {
                    this.onDeletedFields(items);
                    break;
                }
                case 509: 
                case 514: 
                case 561: {
                    this.onRenamedFields(items);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void textUpdated(VWExpressionTextFieldEvent event) {
        Object src = event.getSource();
        if (src == this.m_booleanTextField) {
            this.updateBooleanTextField();
        }
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 516: 
            case 517: 
            case 519: {
                this.initMapComboBox();
            }
        }
    }

    private void updateBooleanTextField() {
        VWInstruction.RollBackCheckPointInstructionSetReDoFlag(this.m_instructionDef, this.m_booleanTextField.getText());
        this.m_authPropertyData.setDirty();
    }

    private void initMapComboBox() {
        this.m_submapComboBox.removeActionListener(this);
        try {
            if (this.m_authPropertyData != null) {
                Object mapName;
                int i;
                this.m_submapComboBox.removeAllItems();
                this.m_submapComboBox.addItem(VWResource.s_noneItemStr);
                this.m_submapComboBox.addItem("Workflow");
                this.m_submapComboBox.addItem("Malfunction");
                this.m_submapComboBox.addItem("Terminate");
                Object[] mapNames = null;
                Vector<Object> mapNamesVec = new Vector<Object>();
                VWMapDefinition[] mapDefs = this.m_authPropertyData.getMapCache().getMapDefinitions();
                if (mapDefs != null) {
                    int len = mapDefs.length;
                    for (i = 0; i < len; ++i) {
                        mapName = mapDefs[i].getName();
                        if (VWStringUtils.compare((String)mapName, "Workflow") == 0 || VWStringUtils.compare((String)mapName, "Malfunction") == 0 || VWStringUtils.compare((String)mapName, "Terminate") == 0) continue;
                        mapNamesVec.addElement(mapName);
                    }
                    mapNames = new String[mapNamesVec.size()];
                    mapNamesVec.copyInto(mapNames);
                }
                if (mapNames != null && mapNames.length > 0) {
                    VWQuickSort sortMap = new VWQuickSort(mapNames, 0);
                    sortMap.sort(0, mapNames.length);
                    for (i = 0; i < mapNames.length; ++i) {
                        mapName = mapNames[i];
                        if (VWStringUtils.compareIgnoreCase((String)mapName, "") == 0) continue;
                        this.m_submapComboBox.addItem(mapName);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_submapComboBox.addActionListener(this);
    }

    private void performGotoAction() {
        try {
            String mapName = (String)this.m_submapComboBox.getSelectedItem();
            this.m_authPropertyData.getToolbarActionNotifier().notifyToolbarAction(this, 503, mapName);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performSubmapAction() {
        try {
            this.m_goToButton.setEnabled(false);
            String submapName = this.m_submapComboBox.getSelectedItem().toString();
            if (VWStringUtils.compare(submapName, VWResource.s_noneItemStr) != 0) {
                boolean bFound = false;
                if (this.m_authPropertyData.getMapCache().isMapExist(submapName, true)) {
                    bFound = true;
                }
                if (bFound) {
                    this.m_goToButton.setEnabled(true);
                }
            } else {
                submapName = null;
            }
            VWInstruction.RollBackCheckPointInstructionSetMap(this.m_instructionDef, submapName);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeletedFields(Vector items) {
        int count;
        String[] nonRollBackFields = VWInstruction.RollBackCheckPointInstructionGetNonRolledBackFieldList(this.m_instructionDef);
        if (nonRollBackFields != null && (count = nonRollBackFields.length) > 0) {
            String deletedFieldName = items.elementAt(0).toString();
            Vector<String> fields = new Vector<String>();
            for (int i = 0; i < count; ++i) {
                if (VWStringUtils.compare(deletedFieldName, nonRollBackFields[i]) == 0) continue;
                fields.addElement(nonRollBackFields[i]);
            }
            Object[] newFieldList = new String[fields.size()];
            fields.copyInto(newFieldList);
            VWInstruction.RollBackCheckPointInstructionSetNonRolledBackFieldList(this.m_instructionDef, (String[])newFieldList);
            this.m_authPropertyData.setDirty();
        }
        this.setInstructionDefinition(this.m_instructionDef);
    }

    private void onRenamedFields(Vector items) {
        int count;
        String[] nonRollBackFields = VWInstruction.RollBackCheckPointInstructionGetNonRolledBackFieldList(this.m_instructionDef);
        if (nonRollBackFields != null && (count = nonRollBackFields.length) > 0) {
            String[] renamedField = (String[])items.elementAt(0);
            String oldName = renamedField[0];
            String newName = renamedField[1];
            for (int i = 0; i < count; ++i) {
                if (VWStringUtils.compare(oldName, nonRollBackFields[i]) != 0) continue;
                nonRollBackFields[i] = newName;
                VWInstruction.RollBackCheckPointInstructionSetNonRolledBackFieldList(this.m_instructionDef, nonRollBackFields);
                this.m_authPropertyData.setDirty();
                break;
            }
        }
        this.setInstructionDefinition(this.m_instructionDef);
    }

    private void initRollBackAddRemoveFieldsPanelValue(String[] nonRollBackFields) {
        try {
            VWFieldDefinition[] fieldDefs;
            if (this.m_authPropertyData != null && (fieldDefs = this.m_authPropertyData.getFields()) != null && fieldDefs.length > 0) {
                Vector<String> fieldsVec = new Vector<String>();
                for (int i = 0; i < fieldDefs.length; ++i) {
                    String fieldName = fieldDefs[i].getName();
                    if (VWStringUtils.compare(fieldName, "F_Trackers") == 0) continue;
                    fieldsVec.addElement(fieldName);
                }
                Object[] availableFields = new String[fieldsVec.size()];
                fieldsVec.copyInto(availableFields);
                this.m_fieldAddRemovePanel.init(this.m_instructionDef, (String[])availableFields, nonRollBackFields);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

